/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

class XYZModel {
    double[][] realXYZ;
    int[][] screenXYZ;
    int[] zOrder;
    int np = -1;
    boolean transformed;
    Matrix3D mat = new Matrix3D();
    double real2Screen = 50.0;
    double ballSize = 0.5;
    Atom atomDefault = new Atom(0.1, 0.7, 0.1, 1.0, 0.5, 0.5, 1.0);
    Atom[] atoms;

    XYZModel() {
    }

    void setAtom(int n, Atom atom) {
        if (n >= 0 && n < this.atoms.length) {
            this.atoms[n] = atom;
        }
    }

    void updateXYZ(double[][] dArray, int n, boolean bl) {
        int n2;
        if (n != this.np) {
            this.np = n;
            this.realXYZ = new double[this.np][3];
            this.screenXYZ = new int[this.np][3];
            this.zOrder = new int[this.np];
            this.atoms = new Atom[this.np];
            for (n2 = 0; n2 < this.np; ++n2) {
                this.atoms[n2] = this.atomDefault;
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            int n3;
            double d = 0.0;
            if (bl) {
                for (n3 = 0; n3 < this.np; ++n3) {
                    d += dArray[n3][n2];
                }
                d /= (double)this.np;
            }
            for (n3 = 0; n3 < this.np; ++n3) {
                this.realXYZ[n3][n2] = dArray[n3][n2] - d;
            }
        }
        this.transformed = false;
    }

    void setMatrix(Matrix3D matrix3D, double d, double d2, double d3) {
        this.mat.unit();
        this.mat.mult(matrix3D);
        this.mat.scale(d, d, d);
        this.real2Screen = d;
        this.mat.translate(d2, d3, 0.0);
        this.transformed = false;
    }

    double getSpan(double[][] dArray, int n) {
        int n2 = dArray[0].length;
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d2;
            double d3 = 1.0E30;
            double d4 = -1.0E30;
            for (int j = 0; j < n; ++j) {
                if (dArray[j][i] < d3) {
                    d3 = dArray[j][i];
                    continue;
                }
                if (!(dArray[j][i] > d4)) continue;
                d4 = dArray[j][i];
            }
            double d5 = d4 - d3;
            if (!(d2 > d)) continue;
            d = d5;
        }
        return d;
    }

    double getScaleFromSpan(double d, int n, int n2) {
        double d2 = (double)n / (d += this.ballSize * 2.0);
        double d3 = (double)n2 / d;
        double d4 = 0.9;
        return (d2 < d3 ? d2 : d3) * d4;
    }

    void getZOrder() {
        int n;
        if (!this.transformed) {
            this.mat.transform(this.realXYZ, this.screenXYZ, this.np);
            this.transformed = true;
        }
        for (n = 0; n < this.np; ++n) {
            this.zOrder[n] = n;
        }
        for (n = 0; n < this.np; ++n) {
            int n2 = n;
            for (int i = n + 1; i < this.np; ++i) {
                if (this.screenXYZ[this.zOrder[i]][2] >= this.screenXYZ[this.zOrder[n2]][2]) continue;
                n2 = i;
            }
            if (n2 == n) continue;
            int n3 = this.zOrder[n];
            this.zOrder[n] = this.zOrder[n2];
            this.zOrder[n2] = n3;
        }
    }

    void drawAtom(Graphics graphics, int n) {
        int n2 = this.zOrder[n];
        Atom atom = this.atoms[n2];
        if (atom == null) {
            return;
        }
        double d = this.screenXYZ[this.zOrder[0]][2];
        double d2 = this.screenXYZ[this.zOrder[this.np - 1]][2];
        int n3 = 15;
        if (d != d2) {
            n3 = (int)(16.0 * ((double)this.screenXYZ[n2][2] - d) / (d2 - d) - 1.0E-6);
        }
        double d3 = this.ballSize * atom.relRadius * this.real2Screen;
        atom.paint(graphics, this.screenXYZ[n2][0], this.screenXYZ[n2][1], n3, d3);
    }

    void paint(Graphics graphics) {
        if (this.realXYZ == null || this.np <= 0) {
            return;
        }
        this.getZOrder();
        for (int i = 0; i < this.np; ++i) {
            this.drawAtom(graphics, i);
        }
    }
}

