/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;

class XYZCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    Image img;
    Graphics imgG;
    Dimension imgSize;
    double realSpan;
    double zoomScale = 1.0;
    public Matrix3D viewMatrix = new Matrix3D();
    private Matrix3D tmpMatrix = new Matrix3D();
    int mouseX;
    int mouseY;
    XYZModel model;
    public static final long serialVersionUID = 2L;

    public XYZCanvas() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public boolean newImgBuf() {
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return false;
        }
        if (this.img != null && this.imgG != null && dimension.equals(this.imgSize)) {
            return true;
        }
        this.img = this.createImage(dimension.width, dimension.height);
        if (this.imgG != null) {
            this.imgG.dispose();
        }
        this.imgG = this.img.getGraphics();
        this.imgSize = dimension;
        return true;
    }

    @Override
    public void update(Graphics graphics) {
        if (this.img == null) {
            graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.paintComponent(graphics);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.model != null) {
            this.newImgBuf();
            Dimension dimension = this.getSize();
            double d = this.model.getScaleFromSpan(this.realSpan, dimension.width, dimension.height);
            this.model.setMatrix(this.viewMatrix, d * this.zoomScale, dimension.width / 2, dimension.height / 2);
            this.imgG.setColor(Color.BLACK);
            this.imgG.fillRect(0, 0, dimension.width, dimension.height);
            this.model.paint(this.imgG);
            graphics.drawImage(this.img, 0, 0, this);
        }
    }

    public void refresh(double[][] dArray, int n, boolean bl, boolean bl2) {
        if (this.model == null) {
            this.model = new XYZModel();
            bl2 = true;
        }
        this.model.updateXYZ(dArray, n, bl);
        if (bl2) {
            this.realSpan = this.model.getSpan(dArray, n);
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.tmpMatrix.unit();
        this.tmpMatrix.xrot(360.0 * (double)(this.mouseY - n2) / (double)this.getSize().height);
        this.tmpMatrix.yrot(360.0 * (double)(n - this.mouseX) / (double)this.getSize().width);
        this.viewMatrix.mult(this.tmpMatrix);
        this.repaint();
        this.mouseX = n;
        this.mouseY = n2;
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        double d;
        int n = mouseWheelEvent.getWheelRotation();
        this.zoomScale -= (double)(0.05f * (float)n);
        if (d < (double)0.09999f) {
            this.zoomScale = 0.1f;
        }
        this.repaint();
    }
}

