/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class NormalModeApp
extends JApplet
implements ActionListener {
    boolean isWin = false;
    NMode nmode;
    double rCutoff = 13.0;
    int nearBy = 3;
    double nearFac = 10000.0;
    boolean modeInit = false;
    int modeID = 7;
    Timer timer;
    int delay = 100;
    int step;
    String pdbIDLocal;
    XYZCanvasProtein canvas;
    JPanel cpnl = new JPanel();
    JTextField tURL = new JTextField("1MBN");
    JTextField tRCutoff = new JTextField("" + this.rCutoff);
    JTextField tNearBy = new JTextField("" + this.nearBy);
    JTextField tNearFac = new JTextField("" + this.nearFac);
    JButton bLoad = new JButton("Compute");
    JTextField tNumRes = new JTextField("");
    JTextField tModeID = new JTextField("" + this.modeID);
    JButton bPlay = new JButton("Play");
    JTextField tEigVal = new JTextField("");
    JTextField tBallSize = new JTextField("0.5");
    JTextField tStickWidth = new JTextField("4.0");
    private static final long serialVersionUID = 1L;
    private int np = -1;
    private double[][] rp;
    DecimalFormat df = new DecimalFormat("###.####");

    @Override
    public void init() {
        this.tURL.setHorizontalAlignment(0);
        this.tRCutoff.setHorizontalAlignment(0);
        this.tNearBy.setHorizontalAlignment(0);
        this.tNearFac.setHorizontalAlignment(0);
        this.tBallSize.setHorizontalAlignment(0);
        this.tStickWidth.setHorizontalAlignment(0);
        this.tModeID.setHorizontalAlignment(0);
        this.tNumRes.setHorizontalAlignment(4);
        this.tEigVal.setHorizontalAlignment(4);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.canvas = new XYZCanvasProtein();
        container.add((Component)this.canvas, "Center");
        container.add((Component)this.cpnl, "East");
        this.cpnl.setLayout(new GridLayout(21, 2));
        this.cpnl.add(new JLabel(" PDB:"));
        this.tURL.addActionListener(this);
        this.cpnl.add(this.tURL);
        JLabel jLabel = new JLabel(" Cutoff (\u212b): ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("Cutoff distance within which two particles are connected by a spring");
        this.tRCutoff.addActionListener(this);
        this.cpnl.add(this.tRCutoff);
        jLabel = new JLabel(" Nres. (nb.): ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("Number of successive residues to be treated as neighbors");
        this.tNearBy.addActionListener(this);
        this.cpnl.add(this.tNearBy);
        jLabel = new JLabel(" K (nb.) ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("Spring constant for neighboring atoms");
        this.tNearFac.addActionListener(this);
        this.cpnl.add(this.tNearFac);
        this.bLoad.addActionListener(this);
        this.bLoad.setToolTipText("Compute all normal modes");
        this.cpnl.add(this.bLoad);
        this.cpnl.add(new JLabel(" # of res.: "));
        this.tNumRes.setEditable(false);
        this.cpnl.add(this.tNumRes);
        this.cpnl.add(new JLabel(" Mode:"));
        this.cpnl.add(this.tModeID);
        this.tModeID.addActionListener(this);
        this.cpnl.add(new JLabel(" Eigval.:"));
        this.tEigVal.setEditable(false);
        this.cpnl.add(this.tEigVal);
        this.bPlay.setEnabled(false);
        this.cpnl.add(this.bPlay);
        this.bPlay.addActionListener(this);
        this.cpnl.add(new JLabel(" Ball radius: "));
        this.tBallSize.addActionListener(this);
        this.cpnl.add(this.tBallSize);
        this.cpnl.add(new JLabel(" Stick width: "));
        this.tStickWidth.addActionListener(this);
        this.cpnl.add(this.tStickWidth);
        try {
            String string = this.tURL.getText();
            this.nmode = new NMode(XYZModelProtein.getPDBInputStream(string, this));
            this.pdbIDLocal = string;
        }
        catch (Exception exception) {
            System.out.printf("Cannot load %s, %s\n", this.tURL.getText(), exception);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.nmode != null && this.nmode.n > 0) {
            if (this.modeInit && this.timer != null) {
                double d;
                if (this.np != this.nmode.n) {
                    this.np = this.nmode.n;
                    this.rp = new double[this.np][3];
                }
                double d2 = d = Math.sqrt(this.nmode.n) * 3.0;
                double d3 = 1.0;
                int n = 6;
                while (this.nmode.val[n] <= 0.0) {
                    ++n;
                }
                double d4 = this.nmode.val[n];
                double d5 = this.nmode.val[this.modeID - 1];
                if (this.modeID - 1 > n) {
                    d2 = d * Math.sqrt(d4 / d5);
                    d3 = Math.sqrt(d5 / d4);
                }
                d2 *= Math.sin((double)(this.step * 2) * Math.PI * d3 / 100.0);
                for (int i = 0; i < this.np; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        this.rp[i][j] = this.nmode.r[i][j] + this.nmode.vec[3 * i + j][this.modeID - 1] * d2;
                    }
                }
                this.canvas.refresh(this.rp, this.np, this.nmode.res, false);
                ++this.step;
            } else {
                this.canvas.refresh(this.nmode.r, this.nmode.n, this.nmode.res, false);
            }
        }
        this.cpnl.repaint();
    }

    private void initPDB(String string) {
        try {
            if (this.nmode == null || string != this.pdbIDLocal) {
                this.nmode = new NMode(XYZModelProtein.getPDBInputStream(string, this));
            }
            this.canvas.refresh(this.nmode.r, this.nmode.n, this.nmode.res, true);
            this.nmode.eig(this.rCutoff, this.nearBy, this.nearFac);
            this.pdbIDLocal = string;
            this.modeInit = true;
        }
        catch (Exception exception) {
            System.out.println("cannot open " + string + ", error: " + exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        XYZModelProtein xYZModelProtein;
        float f;
        Object object = actionEvent.getSource();
        if (object == this.tBallSize) {
            f = Float.parseFloat(this.tBallSize.getText().trim());
            if (f < 0.0f) {
                f = 0.0f;
            }
            xYZModelProtein = (XYZModelProtein)this.canvas.model;
            xYZModelProtein.ballSize = f;
            this.repaint();
        }
        if (object == this.tStickWidth) {
            f = Float.parseFloat(this.tStickWidth.getText().trim());
            if ((double)f < 0.0) {
                f = 0.0f;
            }
            xYZModelProtein = (XYZModelProtein)this.canvas.model;
            xYZModelProtein.stickWidth = f;
            this.repaint();
        }
        if (object == this.tRCutoff) {
            this.rCutoff = Double.parseDouble(this.tRCutoff.getText().trim());
            if (this.rCutoff < 2.0) {
                this.rCutoff = 2.0;
                this.tRCutoff.setText(" " + this.rCutoff);
            }
        }
        if (object == this.tNearBy) {
            this.nearBy = Integer.parseInt(this.tNearBy.getText().trim());
            if (this.nearBy < 0) {
                this.nearBy = 0;
                this.tNearBy.setText(" 0 ");
            }
        }
        if (object == this.tNearFac) {
            this.nearFac = Double.parseDouble(this.tNearFac.getText().trim());
            if (this.nearFac < 0.0) {
                this.nearFac = 0.0;
                this.tNearFac.setText(" 0 ");
            }
        }
        if (object == this.bLoad || object == this.tURL || object == this.tRCutoff || object == this.tNearBy || object == this.tNearFac) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            String string = this.tURL.getText().trim();
            this.bPlay.setEnabled(false);
            this.initPDB(string);
            this.tNumRes.setText(this.nmode.n + "  ");
            this.bPlay.setEnabled(true);
            this.bPlay.setText("Play");
        }
        if (object == this.tModeID) {
            this.modeID = Integer.parseInt(this.tModeID.getText().trim());
            if (this.modeID < 1) {
                this.modeID = 1;
                this.tModeID.setText("" + this.modeID);
            }
            if (this.modeInit && this.modeID > this.nmode.n * 3) {
                this.modeID = this.nmode.n * 3;
                this.tModeID.setText("" + this.modeID);
            }
        }
        boolean bl2 = bl = object == this.bPlay && this.timer == null || object == this.tModeID;
        if (object == this.bPlay) {
            if (this.timer == null) {
                this.bPlay.setText("Stop");
            } else {
                this.timer.stop();
                this.timer = null;
                this.bPlay.setText("Play");
                this.repaint();
            }
        }
        if (bl) {
            if (!this.modeInit) {
                return;
            }
            this.tEigVal.setText(this.df.format(this.nmode.val[this.modeID - 1]) + "  ");
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            this.step = 0;
            this.repaint();
            this.timer = new Timer(this.delay, this);
            this.timer.start();
        }
        if (object == this.timer) {
            if (!this.modeInit) {
                return;
            }
            this.repaint();
        }
    }
}

