/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

class NMode {
    int n = 0;
    int nmax = 1024;
    String[] res;
    double[][] r = new double[this.nmax][3];
    double[][] mat;
    double[] val;
    double[][] vec;
    double rcutoff = 13.0;
    double nearfac = 10000.0;
    int nearby = 3;

    NMode() {
        this.res = new String[this.nmax];
    }

    NMode(InputStream inputStream) throws Exception {
        this();
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("ENDMDL") && !string.startsWith("TER")) {
            String string2;
            if (!string.startsWith("ATOM") || !(string2 = string.substring(12, 16).trim()).equals("CA")) continue;
            this.res[this.n] = string.substring(17, 20).trim();
            this.r[this.n][0] = Double.parseDouble(string.substring(31, 39).trim());
            this.r[this.n][1] = Double.parseDouble(string.substring(39, 47).trim());
            this.r[this.n][2] = Double.parseDouble(string.substring(47, 55).trim());
            ++this.n;
            if (this.n < this.nmax) continue;
            this.nmax += 1024;
            double[][] dArray = new double[this.nmax][3];
            String[] stringArray = new String[this.nmax];
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < 3; ++j) {
                    dArray[i][j] = this.r[i][j];
                }
                stringArray[i] = this.res[i];
            }
            this.r = dArray;
            this.res = stringArray;
        }
        System.out.println("" + this.n + " residues");
    }

    private void buildMatrix() {
        double[] dArray = new double[3];
        this.mat = new double[3 * this.n][3 * this.n];
        for (int i = 0; i < this.n - 1; ++i) {
            for (int j = i + 1; j < this.n; ++j) {
                this.rv3Diff(dArray, this.r[j], this.r[i]);
                double d = this.rv3Norm(dArray);
                if (d > this.rcutoff) continue;
                this.rv3SMul(dArray, 1.0 / d);
                double d2 = j <= i + this.nearby ? this.nearfac : 1.0;
                for (int k = 0; k < 3; ++k) {
                    for (int i2 = 0; i2 < 3; ++i2) {
                        double d3 = dArray[k] * dArray[i2] * d2;
                        double[] dArray2 = this.mat[3 * i + k];
                        int n = 3 * i + i2;
                        dArray2[n] = dArray2[n] + d3;
                        double[] dArray3 = this.mat[3 * i + k];
                        int n2 = 3 * j + i2;
                        dArray3[n2] = dArray3[n2] - d3;
                        double[] dArray4 = this.mat[3 * j + k];
                        int n3 = 3 * i + i2;
                        dArray4[n3] = dArray4[n3] - d3;
                        double[] dArray5 = this.mat[3 * j + k];
                        int n4 = 3 * j + i2;
                        dArray5[n4] = dArray5[n4] + d3;
                    }
                }
            }
        }
    }

    public void eig(double d, int n, double d2) {
        this.rcutoff = d;
        this.nearby = n;
        this.nearfac = d2;
        this.buildMatrix();
        Eig eig = new Eig(this.mat, 3 * this.n);
        this.val = eig.val;
        this.vec = eig.vec;
        for (int i = 0; i < 3 * this.n; ++i) {
            if (i < 20 || i >= 3 * this.n - 3) {
                System.out.println("" + (i + 1) + ": " + this.val[i]);
            }
            if (i != 19) continue;
            System.out.println("...");
        }
    }

    private void rv3Diff(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
        dArray[2] = dArray2[2] - dArray3[2];
    }

    private double rv3Norm(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
    }

    private void rv3SMul(double[] dArray, double d) {
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        dArray[2] = dArray[2] * d;
    }
}

