/*
 * Decompiled with CFR 0.152.
 */
class Eig {
    double[] val;
    double[][] vec;
    double[] e;
    int n;
    static final int itermax = 1000;

    Eig(double[][] dArray, int n) {
        this.n = n;
        this.val = new double[this.n];
        this.vec = new double[this.n][this.n];
        this.e = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.vec[i][j] = dArray[i][j];
            }
        }
        this.tridiag(this.vec, this.val, this.e);
        this.triqr(this.val, this.e, this.vec);
        this.sort(true);
    }

    private void tridiag(double[][] dArray, double[] dArray2, double[] dArray3) {
        double d;
        int n;
        int n2;
        double[] dArray4;
        int n3;
        for (n3 = 0; n3 < this.n; ++n3) {
            dArray2[n3] = 0.0;
        }
        for (n3 = 0; n3 < this.n - 2; ++n3) {
            dArray4 = dArray[n3];
            double d2 = 0.0;
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                d2 += dArray4[n2] * dArray4[n2];
            }
            double d3 = dArray4[n3 + 1] > 0.0 ? Math.sqrt(d2) : -Math.sqrt(d2);
            dArray3[n3] = -d3;
            d2 += d3 * dArray4[n3 + 1];
            if (d3 + dArray[n3][n3] == dArray[n3][n3]) {
                dArray3[n3] = dArray[n3][n3 + 1];
                continue;
            }
            int n4 = n3 + 1;
            dArray4[n4] = dArray4[n4] + d3;
            for (n = n3 + 1; n < this.n; ++n) {
                dArray[n][n3] = dArray4[n] / d2;
            }
            d = 0.0;
            for (n = n3 + 1; n < this.n; ++n) {
                double d4 = 0.0;
                for (n2 = n3 + 1; n2 <= n; ++n2) {
                    d4 += dArray[n2][n] * dArray4[n2];
                }
                for (n2 = n + 1; n2 < this.n; ++n2) {
                    d4 += dArray[n][n2] * dArray4[n2];
                }
                dArray3[n] = d4 /= d2;
                d += dArray4[n] * d4;
            }
            d /= 2.0 * d2;
            for (n = n3 + 1; n < this.n; ++n) {
                int n5 = n;
                dArray3[n5] = dArray3[n5] - d * dArray4[n];
            }
            for (n = n3 + 1; n < this.n; ++n) {
                for (n2 = n; n2 < this.n; ++n2) {
                    double[] dArray5 = dArray[n];
                    int n6 = n2;
                    dArray5[n6] = dArray5[n6] - (dArray3[n] * dArray4[n2] + dArray4[n] * dArray3[n2]);
                }
            }
            dArray2[n3] = 1.0;
        }
        dArray3[this.n - 2] = dArray[this.n - 2][this.n - 1];
        dArray3[this.n - 1] = 0.0;
        dArray2[this.n - 2] = dArray[this.n - 2][this.n - 2];
        dArray2[this.n - 1] = dArray[this.n - 1][this.n - 1];
        dArray[this.n - 2][this.n - 2] = 1.0;
        dArray[this.n - 2][this.n - 1] = 0.0;
        dArray[this.n - 1][this.n - 2] = 0.0;
        dArray[this.n - 1][this.n - 1] = 1.0;
        for (n3 = this.n - 3; n3 >= 0; --n3) {
            dArray4 = dArray[n3];
            if (dArray2[n3] != 0.0) {
                for (n = n3 + 1; n < this.n; ++n) {
                    d = 0.0;
                    for (n2 = n3 + 1; n2 < this.n; ++n2) {
                        d += dArray4[n2] * dArray[n2][n];
                    }
                    for (n2 = n3 + 1; n2 < this.n; ++n2) {
                        double[] dArray6 = dArray[n2];
                        int n7 = n;
                        dArray6[n7] = dArray6[n7] - d * dArray[n2][n3];
                    }
                }
            }
            dArray2[n3] = dArray[n3][n3];
            dArray[n3][n3] = 1.0;
            for (n = n3 + 1; n < this.n; ++n) {
                dArray[n][n3] = 0.0;
                dArray[n3][n] = 0.0;
            }
        }
    }

    private void triqr(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d = 0.0;
        double d2 = 0.0;
        dArray2[this.n - 1] = 0.0;
        double d3 = 1.0E-12f;
        block0: for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < 1000; ++j) {
                int n;
                for (n = i; n < this.n - 1 && !(Math.abs(dArray2[n]) < (Math.abs(dArray[n + 1]) + Math.abs(dArray[n])) * d3); ++n) {
                }
                if (n == i) continue block0;
                double d4 = dArray[n] - dArray[n - 1];
                int n2 = d4 > 0.0 ? 1 : -1;
                double d5 = this.hypot(d4 /= dArray2[n - 1], 1.0);
                d = dArray[n] + (double)n2 * dArray2[n - 1] / (d5 + Math.abs(d4));
                for (int k = i; k <= n - 1; ++k) {
                    double d6;
                    double d7;
                    if (k == i) {
                        d5 = this.hypot(dArray[i] - d, dArray2[i]);
                        d7 = (dArray[i] - d) / d5;
                        d6 = dArray2[i] / d5;
                    } else {
                        d5 = this.hypot(dArray2[k - 1], d2);
                        d7 = dArray2[k - 1] / d5;
                        d6 = d2 / d5;
                        dArray2[k - 1] = d5;
                    }
                    d5 = d6 * (dArray[k + 1] - dArray[k]) + 2.0 * d7 * dArray2[k];
                    int n3 = k;
                    dArray[n3] = dArray[n3] + d6 * d5;
                    int n4 = k + 1;
                    dArray[n4] = dArray[n4] - d6 * d5;
                    dArray2[k] = d7 * d5 - dArray2[k];
                    d2 = d6 * dArray2[k + 1];
                    int n5 = k + 1;
                    dArray2[n5] = dArray2[n5] * d7;
                    for (int i2 = 0; i2 < this.n; ++i2) {
                        double d8 = dArray3[i2][k];
                        double d9 = dArray3[i2][k + 1];
                        dArray3[i2][k] = d7 * d8 + d6 * d9;
                        dArray3[i2][k + 1] = -d6 * d8 + d7 * d9;
                    }
                }
            }
        }
    }

    public void sort(boolean bl) {
        for (int i = 0; i < this.n - 1; ++i) {
            int n;
            double d = this.val[i];
            int n2 = i;
            for (n = i + 1; n < this.n; ++n) {
                if (bl) {
                    if (!(this.val[n] < d)) continue;
                    n2 = n;
                    d = this.val[n2];
                    continue;
                }
                if (!(this.val[n] > d)) continue;
                n2 = n;
                d = this.val[n2];
            }
            if (n2 == i) continue;
            double d2 = this.val[i];
            this.val[i] = this.val[n2];
            this.val[n2] = d2;
            for (n = 0; n < this.n; ++n) {
                d2 = this.vec[n][i];
                this.vec[n][i] = this.vec[n][n2];
                this.vec[n][n2] = d2;
            }
        }
    }

    private double hypot(double d, double d2) {
        if ((d = Math.abs(d)) > (d2 = Math.abs(d2))) {
            return d * Math.sqrt(1.0 + (d2 /= d) * d2);
        }
        if (d2 > 0.0) {
            return d2 * Math.sqrt(1.0 + (d /= d2) * d);
        }
        return 0.0;
    }

    public static final void main() {
        int n;
        int n2;
        int n3 = 3;
        double[][] dArray = new double[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray[n2][n] = 1.0;
            }
            dArray[n2][n2] = n2 + 1;
        }
        Eig eig = new Eig(dArray, n3);
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.println("" + n2 + ": " + eig.val[n2] + ";");
            for (n = 0; n < n3; ++n) {
                System.out.println("" + eig.vec[n][n2] + " ");
            }
        }
    }
}

