/*
 * Decompiled with CFR 0.152.
 */
class rv3 {
    static double[] dx = new double[3];
    static double[] x12 = new double[3];
    static double[] x32 = new double[3];
    static double[] x34 = new double[3];
    static double[] m = new double[3];
    static double[] n = new double[3];
    static double[] uvec = new double[3];
    static double[] vvec = new double[3];
    static double[] svec = new double[3];

    rv3() {
    }

    static void zero(double[] dArray) {
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
    }

    static double[] diff(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
        dArray[2] = dArray2[2] - dArray3[2];
        return dArray;
    }

    static void inc(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] + dArray2[0];
        dArray[1] = dArray[1] + dArray2[1];
        dArray[2] = dArray[2] + dArray2[2];
    }

    static void sinc(double[] dArray, double[] dArray2, double d) {
        dArray[0] = dArray[0] + d * dArray2[0];
        dArray[1] = dArray[1] + d * dArray2[1];
        dArray[2] = dArray[2] + d * dArray2[2];
    }

    static double dot(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    static double dist2(double[] dArray, double[] dArray2) {
        rv3.diff(dx, dArray, dArray2);
        return rv3.sqr(dx);
    }

    static double dist(double[] dArray, double[] dArray2) {
        return Math.sqrt(rv3.dist2(dArray, dArray2));
    }

    static double sqr(double[] dArray) {
        return dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
    }

    static double norm(double[] dArray) {
        return Math.sqrt(rv3.sqr(dArray));
    }

    static void smul(double[] dArray, double d) {
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        dArray[2] = dArray[2] * d;
    }

    static void smul2(double[] dArray, double[] dArray2, double d) {
        dArray[0] = dArray2[0] * d;
        dArray[1] = dArray2[1] * d;
        dArray[2] = dArray2[2] * d;
    }

    static double[] lincomb2(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2) {
        dArray[0] = dArray2[0] * d + dArray3[0] * d2;
        dArray[1] = dArray2[1] * d + dArray3[1] * d2;
        dArray[2] = dArray2[2] * d + dArray3[2] * d2;
        return dArray;
    }

    static double[] cross(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[2] = dArray2[0] * dArray3[1] - dArray2[1] * dArray3[0];
        dArray[0] = dArray2[1] * dArray3[2] - dArray2[2] * dArray3[1];
        dArray[1] = dArray2[2] * dArray3[0] - dArray2[0] * dArray3[2];
        return dArray;
    }

    static double cosang(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        double d = rv3.norm(rv3.diff(x12, dArray, dArray2));
        rv3.smul(x12, 1.0 / d);
        double d2 = rv3.norm(rv3.diff(x32, dArray3, dArray2));
        rv3.smul(x32, 1.0 / d2);
        double d3 = rv3.dot(x12, x32);
        if (d3 > 1.0) {
            d3 = 1.0;
        } else if (d3 < -1.0) {
            d3 = -1.0;
        }
        if (dArray4 != null && dArray5 != null && dArray6 != null) {
            rv3.lincomb2(dArray4, x32, x12, 1.0 / d, -d3 / d);
            rv3.lincomb2(dArray6, x12, x32, 1.0 / d2, -d3 / d2);
            rv3.lincomb2(dArray5, dArray4, dArray6, -1.0, -1.0);
        }
        return d3;
    }

    static double ang(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        double d = rv3.cosang(dArray, dArray2, dArray3, dArray4, dArray5, dArray6);
        double d2 = Math.sqrt(1.0 - d * d);
        d2 = d2 < 1.0E-7 ? 1.0 : -1.0 / d2;
        if (dArray4 != null && dArray5 != null && dArray6 != null) {
            rv3.smul(dArray4, d2);
            rv3.smul(dArray5, d2);
            rv3.smul(dArray6, d2);
        }
        return Math.acos(d);
    }

    static double dih(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) {
        rv3.diff(x12, dArray, dArray2);
        rv3.diff(x32, dArray3, dArray2);
        rv3.diff(x34, dArray3, dArray4);
        double d = rv3.sqr(x32);
        double d2 = Math.sqrt(d);
        double d3 = d * (double)1.0E-16f;
        rv3.cross(m, x12, x32);
        double d4 = rv3.sqr(m);
        rv3.cross(n, x32, x34);
        double d5 = rv3.sqr(n);
        double d6 = 1.0;
        if (d4 > d3 && d5 > d3) {
            d6 = rv3.dot(m, n) / Math.sqrt(d4 * d5);
            if (d6 > 1.0) {
                d6 = 1.0;
            } else if (d6 < -1.0) {
                d6 = -1.0;
            }
        }
        double d7 = Math.acos(d6);
        double d8 = rv3.dot(n, x12);
        double d9 = d8 > 0.0 ? 1.0 : -1.0;
        d7 *= d9;
        if (dArray5 != null && dArray6 != null && dArray7 != null && dArray8 != null) {
            rv3.smul2(dArray5, m, d2 / d4);
            rv3.smul2(dArray8, n, -d2 / d5);
            double d10 = rv3.dot(x12, x32) / d;
            rv3.smul2(uvec, dArray5, d10);
            double d11 = rv3.dot(x34, x32) / d;
            rv3.smul2(vvec, dArray8, d11);
            rv3.diff(svec, uvec, vvec);
            rv3.lincomb2(dArray6, svec, dArray5, 1.0, -1.0);
            rv3.lincomb2(dArray7, svec, dArray8, -1.0, -1.0);
        }
        return d7;
    }
}

