/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;

class XYZModelProtein
extends XYZModel {
    boolean useStick = true;
    double stickWidth = 4.0;
    static Hashtable<String, Atom> resTable = new Hashtable();
    static Hashtable<String, Atom> atomTable;
    Atom atomGrey;
    int maxVert;

    XYZModelProtein() {
        atomTable.put("H", new Atom(0.7, 0.7, 0.7, 1.0, 0.7, 0.4, 2.0));
        atomTable.put("C", new Atom(0.0, 0.7, 0.7, 1.7, 0.7, 0.4, 2.0));
        atomTable.put("N", new Atom(0.0, 0.0, 0.9, 1.55, 0.7, 0.4, 2.0));
        atomTable.put("O", new Atom(1.0, 0.0, 0.0, 1.52, 0.7, 0.4, 2.0));
        atomTable.put("S", new Atom(0.7, 0.7, 0.0, 1.8, 0.7, 0.4, 2.0));
        atomTable.put("F", new Atom(0.7, 0.1, 0.7, 1.47, 0.7, 0.4, 2.0));
        atomTable.put("P", new Atom(0.7, 0.0, 0.7, 1.8, 0.7, 0.4, 2.0));
        atomTable.put("CL", new Atom(0.7, 0.7, 0.4, 1.75, 0.7, 0.4, 2.0));
        atomTable.put("CU", new Atom(0.6, 0.3, 0.0, 1.4, 0.7, 0.4, 2.0));
        this.atomGrey = new Atom(0.5, 0.5, 0.5);
        this.maxVert = 0;
        this.atomDefault = this.atomGrey;
    }

    static InputStream getPDBInputStream(String string, Applet applet) {
        string = string.trim().toUpperCase() + ".pdb";
        InputStream inputStream = null;
        URL uRL = null;
        try {
            uRL = applet.getCodeBase();
        }
        catch (NullPointerException nullPointerException) {
            File file = new File(System.getProperty("user.dir"));
            try {
                uRL = file.toURI().toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            inputStream = new URL(uRL, string).openStream();
            if (inputStream != null) {
                return inputStream;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inputStream = new URL("http://www.rcsb.org/pdb/files/" + string).openStream();
        }
        catch (Exception exception) {
            System.out.println("Failed to download " + string);
        }
        return inputStream;
    }

    double parsePDB(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.np = 0;
        this.maxVert = 0;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("TER") || string.startsWith("ENDMDL") || !string.startsWith("ATOM")) continue;
                String string2 = string.substring(12, 16).trim();
                String string3 = Character.isDigit(string2.charAt(0)) ? string2.substring(1, 2) : string2.substring(0, 1);
                double d = Double.parseDouble(string.substring(31, 39).trim());
                double d2 = Double.parseDouble(string.substring(39, 47).trim());
                double d3 = Double.parseDouble(string.substring(47, 55).trim());
                this.addVert(string3, d, d2, d3);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.updateXYZ(this.realXYZ, this.np, true);
        this.useStick = false;
        return this.getSpan(this.realXYZ, this.np);
    }

    double loadPDB(String string, Applet applet) {
        InputStream inputStream = XYZModelProtein.getPDBInputStream(string, applet);
        double d = 0.0;
        if (inputStream != null) {
            d = this.parsePDB(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    int addVert(String string, double d, double d2, double d3) {
        Object object;
        int n = this.np;
        if (n >= this.maxVert) {
            if (this.realXYZ == null) {
                this.maxVert = 100;
                this.realXYZ = new double[this.maxVert][3];
                this.atoms = new Atom[this.maxVert];
                this.screenXYZ = new int[this.maxVert][3];
                this.zOrder = new int[this.maxVert];
            } else {
                this.maxVert *= 2;
                object = new double[this.maxVert][3];
                System.arraycopy(this.realXYZ, 0, object, 0, this.realXYZ.length);
                this.realXYZ = (double[][])object;
                Atom[] atomArray = new Atom[this.maxVert];
                System.arraycopy(this.atoms, 0, atomArray, 0, this.atoms.length);
                this.atoms = atomArray;
                this.screenXYZ = new int[this.maxVert][3];
                this.zOrder = new int[this.maxVert];
            }
        }
        this.atoms[n] = (object = atomTable.get(string.toUpperCase())) == null ? this.atomDefault : object;
        this.realXYZ[n][0] = d;
        this.realXYZ[n][1] = d2;
        this.realXYZ[n][2] = d3;
        return this.np++;
    }

    void updateRes(String[] stringArray, int n) {
        for (int i = 0; i < n; ++i) {
            Atom atom = resTable.get(stringArray[i].toUpperCase());
            this.atoms[i] = atom == null ? this.atomDefault : atom;
        }
    }

    private int zOrderWho(int n) {
        for (int i = 0; i < this.np; ++i) {
            if (this.zOrder[i] != n) continue;
            return i;
        }
        return -1;
    }

    void drawStick(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = 50 + 150 * n / this.np;
        graphics.setColor(new Color(n2, n2, n2));
        int n3 = this.zOrder[n];
        if (n3 < this.np - 1 && this.zOrderWho(n3 + 1) > n) {
            graphics2D.drawLine(this.screenXYZ[n3][0], this.screenXYZ[n3][1], this.screenXYZ[n3 + 1][0], this.screenXYZ[n3 + 1][1]);
        }
        if (n3 > 0 && this.zOrderWho(n3 - 1) > n) {
            graphics2D.drawLine(this.screenXYZ[n3][0], this.screenXYZ[n3][1], this.screenXYZ[n3 - 1][0], this.screenXYZ[n3 - 1][1]);
        }
    }

    @Override
    void paint(Graphics graphics) {
        if (this.realXYZ == null || this.np <= 0) {
            return;
        }
        this.getZOrder();
        if (this.useStick) {
            BasicStroke basicStroke = new BasicStroke((float)((double)0.1f * this.real2Screen * this.stickWidth), 1, 1);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(basicStroke);
        }
        for (int i = 0; i < this.np; ++i) {
            this.drawAtom(graphics, i);
            if (!this.useStick) continue;
            this.drawStick(graphics, i);
        }
    }

    static {
        resTable.put("GLY", new Atom(1.0, 1.0, 1.0, 1.8));
        resTable.put("ALA", new Atom(0.8, 1.0, 1.0, 2.0));
        resTable.put("VAL", new Atom(0.5, 0.9, 0.9, 2.6));
        resTable.put("LEU", new Atom(0.6, 0.8, 0.8, 2.8));
        resTable.put("ILE", new Atom(0.6, 0.8, 0.8, 2.8, 0.7, 0.4, 2.0));
        resTable.put("PRO", new Atom(0.6, 0.8, 0.8, 2.6, 0.7, 0.4, 2.0));
        resTable.put("SER", new Atom(0.9, 0.7, 1.0, 2.4, 0.7, 0.4, 2.0));
        resTable.put("THR", new Atom(0.7, 0.6, 0.8, 2.6, 0.7, 0.4, 2.0));
        resTable.put("CYS", new Atom(1.0, 1.0, 0.0, 2.4, 0.7, 0.4, 2.0));
        resTable.put("MET", new Atom(0.6, 0.6, 0.0, 2.8, 0.7, 0.4, 2.0));
        resTable.put("ASN", new Atom(0.2, 1.0, 0.4, 2.8, 0.7, 0.4, 2.0));
        resTable.put("GLN", new Atom(0.0, 0.8, 0.2, 3.0, 0.7, 0.4, 2.0));
        resTable.put("ASP", new Atom(1.0, 0.0, 0.0, 2.8, 0.7, 0.4, 2.0));
        resTable.put("GLU", new Atom(1.0, 0.2, 0.0, 3.0, 0.7, 0.4, 2.0));
        resTable.put("LYS", new Atom(0.0, 0.4, 1.0, 3.0, 0.7, 0.4, 2.0));
        resTable.put("ARG", new Atom(0.0, 0.0, 1.0, 3.4, 0.7, 0.4, 2.0));
        resTable.put("HIS", new Atom(0.0, 0.4, 0.8, 3.0, 0.7, 0.4, 2.0));
        resTable.put("PHE", new Atom(0.5, 0.7, 0.7, 3.0, 0.7, 0.4, 2.0));
        resTable.put("TYR", new Atom(0.4, 0.6, 0.6, 3.6, 0.7, 0.4, 2.0));
        resTable.put("TRP", new Atom(0.3, 0.5, 0.5, 4.0, 0.7, 0.4, 2.0));
        atomTable = new Hashtable();
    }
}

