/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;

class WL {
    double emin;
    double emax;
    double de;
    int ecnt = 40;
    double[] hist;
    double[] lng;
    double lnf = lnf0;
    int step = 0;
    double flatness;
    double epot;
    double beta;
    static double lnf0 = 0.1;
    static double lnffac = 0.5;
    static double perc = 0.2;
    static int nstcheck = 10000;
    DecimalFormat df = new DecimalFormat("####.00");
    DecimalFormat dfh = new DecimalFormat("######.0");
    static double betmin = -1.0;
    static double betmax = 10.0;

    WL(double d, double d2) {
        this.emin = d;
        this.emax = d2;
        this.de = (this.emax - this.emin) / (double)this.ecnt;
        this.hist = new double[this.ecnt + 1];
        this.lng = new double[this.ecnt + 1];
        this.lnf = lnf0;
        this.step = 0;
        this.flatness = 1.0;
    }

    double histogramFlatness() {
        double d = 1.0E9;
        double d2 = -1.0E9;
        for (int i = 0; i < this.ecnt; ++i) {
            if (this.hist[i] > d2) {
                d2 = this.hist[i];
                continue;
            }
            if (!(this.hist[i] < d)) continue;
            d = this.hist[i];
        }
        if (d2 > 0.0) {
            return (d2 - d) / (d2 + d);
        }
        return 1.0;
    }

    void dump() {
        for (int i = 0; i <= this.ecnt; ++i) {
            System.out.println("E " + this.df.format(this.emin + ((double)i + 0.5) * this.de) + " hist " + this.dfh.format(this.hist[i]) + " S " + this.df.format(this.lng[i]));
        }
        System.out.println("flatness " + this.flatness + " lnf " + this.lnf + " epot " + this.epot + " beta " + this.beta);
    }

    int check() {
        int n = this.ecnt;
        while (n >= 0) {
            int n2 = n--;
            this.lng[n2] = this.lng[n2] - this.lng[0];
        }
        this.flatness = this.histogramFlatness();
        this.dump();
        if (this.flatness < perc) {
            System.out.println("switch stages step " + this.step);
            this.lnf *= lnffac;
            for (n = 0; n < this.ecnt; ++n) {
                this.hist[n] = 0.0;
            }
            return 1;
        }
        return 0;
    }

    private double limit(double d) {
        if (d < betmin) {
            return betmin;
        }
        if (d > betmax) {
            return betmax;
        }
        return d;
    }

    double add(double d) {
        int n;
        int n2;
        this.epot = d;
        int n3 = -1;
        if (d < this.emin) {
            n2 = 0;
            n = 0;
        } else if (d >= this.emax) {
            n2 = this.ecnt;
            n = this.ecnt - 1;
            n3 = this.ecnt;
        } else {
            n2 = (int)((d - this.emin) / this.de + 0.5);
            n = n3 = (int)((d - this.emin) / this.de);
        }
        int n4 = n2;
        this.lng[n4] = this.lng[n4] + this.lnf;
        if (n3 > 0) {
            int n5 = n3;
            this.hist[n5] = this.hist[n5] + 1.0;
        }
        ++this.step;
        if (this.step % nstcheck == 0) {
            this.check();
        }
        this.beta = this.limit((this.lng[n + 1] - this.lng[n]) / this.de);
        return this.beta;
    }
}

