/*
 * Decompiled with CFR 0.152.
 */
class Matrix3D {
    double xx = 1.0;
    double xy;
    double xz;
    double xo;
    double yx;
    double yy = 1.0;
    double yz;
    double yo;
    double zx;
    double zy;
    double zz = 1.0;
    double zo;
    static final double pi = 3.14159265;

    Matrix3D() {
    }

    void scale(double d, double d2, double d3) {
        this.xx *= d;
        this.xy *= d;
        this.xz *= d;
        this.xo *= d;
        this.yx *= d2;
        this.yy *= d2;
        this.yz *= d2;
        this.yo *= d2;
        this.zx *= d3;
        this.zy *= d3;
        this.zz *= d3;
        this.zo *= d3;
    }

    void translate(double d, double d2, double d3) {
        this.xo += d;
        this.yo += d2;
        this.zo += d3;
    }

    void yrot(double d) {
        double d2 = Math.cos(d *= 0.017453292500000002);
        double d3 = Math.sin(d);
        double d4 = this.xx * d2 + this.zx * d3;
        double d5 = this.xy * d2 + this.zy * d3;
        double d6 = this.xz * d2 + this.zz * d3;
        double d7 = this.xo * d2 + this.zo * d3;
        double d8 = this.zx * d2 - this.xx * d3;
        double d9 = this.zy * d2 - this.xy * d3;
        double d10 = this.zz * d2 - this.xz * d3;
        double d11 = this.zo * d2 - this.xo * d3;
        this.xo = d7;
        this.xx = d4;
        this.xy = d5;
        this.xz = d6;
        this.zo = d11;
        this.zx = d8;
        this.zy = d9;
        this.zz = d10;
    }

    void xrot(double d) {
        double d2 = Math.cos(d *= 0.017453292500000002);
        double d3 = Math.sin(d);
        double d4 = this.yx * d2 + this.zx * d3;
        double d5 = this.yy * d2 + this.zy * d3;
        double d6 = this.yz * d2 + this.zz * d3;
        double d7 = this.yo * d2 + this.zo * d3;
        double d8 = this.zx * d2 - this.yx * d3;
        double d9 = this.zy * d2 - this.yy * d3;
        double d10 = this.zz * d2 - this.yz * d3;
        double d11 = this.zo * d2 - this.yo * d3;
        this.yo = d7;
        this.yx = d4;
        this.yy = d5;
        this.yz = d6;
        this.zo = d11;
        this.zx = d8;
        this.zy = d9;
        this.zz = d10;
    }

    void zrot(double d) {
        double d2 = Math.cos(d *= 0.017453292500000002);
        double d3 = Math.sin(d);
        double d4 = this.yx * d2 + this.xx * d3;
        double d5 = this.yy * d2 + this.xy * d3;
        double d6 = this.yz * d2 + this.xz * d3;
        double d7 = this.yo * d2 + this.xo * d3;
        double d8 = this.xx * d2 - this.yx * d3;
        double d9 = this.xy * d2 - this.yy * d3;
        double d10 = this.xz * d2 - this.yz * d3;
        double d11 = this.xo * d2 - this.yo * d3;
        this.yo = d7;
        this.yx = d4;
        this.yy = d5;
        this.yz = d6;
        this.xo = d11;
        this.xx = d8;
        this.xy = d9;
        this.xz = d10;
    }

    void mult(Matrix3D matrix3D) {
        double d = this.xx * matrix3D.xx + this.yx * matrix3D.xy + this.zx * matrix3D.xz;
        double d2 = this.xy * matrix3D.xx + this.yy * matrix3D.xy + this.zy * matrix3D.xz;
        double d3 = this.xz * matrix3D.xx + this.yz * matrix3D.xy + this.zz * matrix3D.xz;
        double d4 = this.xo * matrix3D.xx + this.yo * matrix3D.xy + this.zo * matrix3D.xz + matrix3D.xo;
        double d5 = this.xx * matrix3D.yx + this.yx * matrix3D.yy + this.zx * matrix3D.yz;
        double d6 = this.xy * matrix3D.yx + this.yy * matrix3D.yy + this.zy * matrix3D.yz;
        double d7 = this.xz * matrix3D.yx + this.yz * matrix3D.yy + this.zz * matrix3D.yz;
        double d8 = this.xo * matrix3D.yx + this.yo * matrix3D.yy + this.zo * matrix3D.yz + matrix3D.yo;
        double d9 = this.xx * matrix3D.zx + this.yx * matrix3D.zy + this.zx * matrix3D.zz;
        double d10 = this.xy * matrix3D.zx + this.yy * matrix3D.zy + this.zy * matrix3D.zz;
        double d11 = this.xz * matrix3D.zx + this.yz * matrix3D.zy + this.zz * matrix3D.zz;
        double d12 = this.xo * matrix3D.zx + this.yo * matrix3D.zy + this.zo * matrix3D.zz + matrix3D.zo;
        this.xx = d;
        this.xy = d2;
        this.xz = d3;
        this.xo = d4;
        this.yx = d5;
        this.yy = d6;
        this.yz = d7;
        this.yo = d8;
        this.zx = d9;
        this.zy = d10;
        this.zz = d11;
        this.zo = d12;
    }

    void unit() {
        this.xo = 0.0;
        this.xx = 1.0;
        this.xy = 0.0;
        this.xz = 0.0;
        this.yo = 0.0;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yz = 0.0;
        this.zo = 0.0;
        this.zx = 0.0;
        this.zy = 0.0;
        this.zz = 1.0;
    }

    void transform(double[][] dArray, int[][] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            double d = dArray[i][0];
            double d2 = dArray[i][1];
            double d3 = dArray[i][2];
            nArray[i][0] = (int)(this.xx * d + this.xy * d2 + this.xz * d3 + this.xo);
            nArray[i][1] = (int)(this.yx * d + this.yy * d2 + this.yz * d3 + this.yo);
            nArray[i][2] = (int)(this.zx * d + this.zy * d2 + this.zz * d3 + this.zo);
        }
    }
}

