/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;

public class GoApp
extends JApplet
implements ActionListener {
    boolean isWin = false;
    Go go;
    boolean sysInit = false;
    Timer timer;
    int delay = 100;
    int speed = 100;
    int step = 0;
    XYZCanvasProtein canvas;
    JPanel cpnl = new JPanel();
    JTextField tURL = new JTextField("1VII");
    JTextField tRCutoff = new JTextField("" + Go.rc);
    JTextField tKb = new JTextField("" + Go.kb);
    JTextField tKa = new JTextField("" + Go.ka);
    JTextField tKd1 = new JTextField("" + Go.kd1);
    JTextField tKd3 = new JTextField("" + Go.kd3);
    JTextField tNbe = new JTextField("" + Go.nbe);
    JTextField tNbc = new JTextField("" + Go.nbc);
    JButton bLoad = new JButton("Load");
    JTextField tNumRes = new JTextField("");
    JButton bPlay = new JButton("Start");
    JCheckBox bUseWL = new JCheckBox("Wang-Landau");
    JTextField tLnf0 = new JTextField("" + WL.lnf0);
    JTextField tPerc = new JTextField("" + WL.perc * 100.0);
    JTextField tLnf = new JTextField("");
    JTextField tFlatness = new JTextField("");
    JTextField tSpeed = new JTextField("" + this.speed);
    JTextField tTemp = new JTextField("" + Go.getT());
    JTextField tBallSize = new JTextField(" 0.5");
    JTextField tStickWidth = new JTextField(" 4.0");
    JTextField tEpot = new JTextField("");
    JTextField tEkin = new JTextField("");
    private static final long serialVersionUID = 1L;
    DecimalFormat df = new DecimalFormat("####.###");
    DecimalFormat dfsci = new DecimalFormat("0.0E0");
    DecimalFormat dfper = new DecimalFormat("##.##%");

    @Override
    public void init() {
        this.tURL.setHorizontalAlignment(0);
        this.tRCutoff.setHorizontalAlignment(0);
        this.tKb.setHorizontalAlignment(0);
        this.tKa.setHorizontalAlignment(0);
        this.tKd1.setHorizontalAlignment(0);
        this.tKd3.setHorizontalAlignment(0);
        this.tNbe.setHorizontalAlignment(0);
        this.tNbc.setHorizontalAlignment(0);
        this.tNumRes.setHorizontalAlignment(0);
        this.tLnf0.setHorizontalAlignment(0);
        this.tPerc.setHorizontalAlignment(0);
        this.tLnf.setHorizontalAlignment(0);
        this.tFlatness.setHorizontalAlignment(0);
        this.tSpeed.setHorizontalAlignment(0);
        this.tTemp.setHorizontalAlignment(0);
        this.tBallSize.setHorizontalAlignment(0);
        this.tStickWidth.setHorizontalAlignment(0);
        this.tEpot.setHorizontalAlignment(4);
        this.tEkin.setHorizontalAlignment(4);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.canvas = new XYZCanvasProtein();
        container.add((Component)this.canvas, "Center");
        container.add((Component)this.cpnl, "East");
        this.cpnl.setLayout(new GridLayout(22, 2));
        this.cpnl.add(new JLabel(" PDB:"));
        this.tURL.addActionListener(this);
        this.cpnl.add(this.tURL);
        this.bLoad.addActionListener(this);
        this.bLoad.setToolTipText("Load PDB structure");
        this.cpnl.add(this.bLoad);
        this.bPlay.addActionListener(this);
        this.bPlay.setToolTipText("Start MD simulation");
        this.cpnl.add(this.bPlay);
        this.cpnl.add(new JLabel(" # of res.: "));
        this.tNumRes.setEditable(false);
        this.cpnl.add(this.tNumRes);
        JLabel jLabel = new JLabel(" Cutoff (\u212b): ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("Cutoff distance within which two particles are connected");
        this.tRCutoff.addActionListener(this);
        this.cpnl.add(this.tRCutoff);
        jLabel = new JLabel(" kb ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("Spring constant for harmonic bonds");
        this.tKb.addActionListener(this);
        this.cpnl.add(this.tKb);
        jLabel = new JLabel(" ka ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("Spring constant for harmonic bond angles");
        this.tKa.addActionListener(this);
        this.cpnl.add(this.tKa);
        jLabel = new JLabel(" kd1 ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("Spring constant for dihedral angles");
        this.tKd1.addActionListener(this);
        this.cpnl.add(this.tKd1);
        jLabel = new JLabel(" kd3 ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("Spring constant for dihedral angles");
        this.tKd3.addActionListener(this);
        this.cpnl.add(this.tKd3);
        jLabel = new JLabel(" \u03b5 ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("eplison for nonboned interaction");
        this.tNbe.addActionListener(this);
        this.cpnl.add(this.tNbe);
        jLabel = new JLabel(" rp (\u212b) ");
        this.cpnl.add(jLabel);
        jLabel.setToolTipText("radius of repulsion");
        this.tNbc.addActionListener(this);
        this.cpnl.add(this.tNbc);
        jLabel = new JLabel(" Speed: ");
        this.cpnl.add(jLabel);
        this.tSpeed.addActionListener(this);
        this.cpnl.add(this.tSpeed);
        jLabel = new JLabel(" T (K): ");
        this.cpnl.add(jLabel);
        this.tTemp.addActionListener(this);
        this.cpnl.add(this.tTemp);
        jLabel = new JLabel(" Epot. ");
        this.cpnl.add(jLabel);
        this.tEpot.setEditable(false);
        this.cpnl.add(this.tEpot);
        jLabel = new JLabel(" Tkin (K) ");
        this.cpnl.add(jLabel);
        this.tEkin.setEditable(false);
        this.cpnl.add(this.tEkin);
        this.bUseWL.addActionListener(this);
        this.cpnl.add(this.bUseWL);
        this.cpnl.add(new JLabel(""));
        jLabel = new JLabel(" lnf0:");
        this.cpnl.add(jLabel);
        this.tLnf0.addActionListener(this);
        this.cpnl.add(this.tLnf0);
        jLabel = new JLabel(" H. cutoff (%):");
        this.cpnl.add(jLabel);
        this.tPerc.addActionListener(this);
        this.cpnl.add(this.tPerc);
        jLabel = new JLabel(" lnf:");
        this.cpnl.add(jLabel);
        this.tLnf.setEditable(false);
        this.cpnl.add(this.tLnf);
        jLabel = new JLabel(" H. flatness:");
        this.cpnl.add(jLabel);
        this.tFlatness.setEditable(false);
        this.cpnl.add(this.tFlatness);
        this.cpnl.add(new JLabel(" Ball radius: "));
        this.tBallSize.addActionListener(this);
        this.cpnl.add(this.tBallSize);
        this.cpnl.add(new JLabel(" Stick width: "));
        this.tStickWidth.addActionListener(this);
        this.cpnl.add(this.tStickWidth);
        try {
            String string = this.tURL.getText();
            this.go = new Go(XYZModelProtein.getPDBInputStream(string, this));
        }
        catch (Exception exception) {
            System.out.printf("Cannot load %s, %s\n", this.tURL, exception);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.go != null && this.go.n > 0) {
            if (this.sysInit) {
                ++this.step;
                this.canvas.refresh(this.go.x, this.go.n, this.go.res, false);
            } else {
                this.canvas.refresh(this.go.xref, this.go.n, this.go.res, false);
            }
        }
        this.cpnl.repaint();
    }

    private void initPDB(String string) {
        try {
            this.go = new Go(XYZModelProtein.getPDBInputStream(string, this));
            this.go.initSys();
            this.canvas.refresh(this.go.x, this.go.n, this.go.res, false);
            this.sysInit = true;
        }
        catch (Exception exception) {
            System.out.println("cannot open " + string + ", error: " + exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        double d;
        XYZModelProtein xYZModelProtein;
        float f;
        Object object = actionEvent.getSource();
        if (object == this.tBallSize) {
            f = Float.parseFloat(this.tBallSize.getText().trim());
            if (f < 0.0f) {
                f = 0.0f;
            }
            xYZModelProtein = (XYZModelProtein)this.canvas.model;
            xYZModelProtein.ballSize = f;
            this.repaint();
        }
        if (object == this.tStickWidth) {
            f = Float.parseFloat(this.tStickWidth.getText().trim());
            if ((double)f < 0.0) {
                f = 0.0f;
            }
            xYZModelProtein = (XYZModelProtein)this.canvas.model;
            xYZModelProtein.stickWidth = f;
            this.repaint();
        }
        if (object == this.tTemp) {
            double d2 = Double.parseDouble(this.tTemp.getText().trim());
            if (d2 < 0.0) {
                d2 = 0.0;
                this.tTemp.setText(" " + d2);
            }
            Go.setT(d2);
        }
        if (object == this.tSpeed) {
            this.speed = Integer.parseInt(this.tSpeed.getText().trim());
        }
        boolean bl2 = false;
        if (object == this.tRCutoff) {
            double d3 = Double.parseDouble(this.tRCutoff.getText().trim());
            if (d3 < 6.0) {
                d3 = 6.0;
                this.tRCutoff.setText("" + d3);
            }
            Go.rc = d3;
            bl2 = true;
        }
        if (object == this.tKb) {
            double d4 = Double.parseDouble(this.tKb.getText().trim());
            if (d4 < 0.0) {
                d4 = 0.0;
                this.tKb.setText("0");
            }
            Go.kb = d4;
            bl2 = true;
        }
        if (object == this.tKa) {
            double d5 = Double.parseDouble(this.tKa.getText().trim());
            if (d5 < 0.0) {
                d5 = 0.0;
                this.tKa.setText("0");
            }
            Go.ka = d5;
            bl2 = true;
        }
        if (object == this.tKd1) {
            double d6 = Double.parseDouble(this.tKd1.getText().trim());
            if (d6 < 0.0) {
                d6 = 0.0;
                this.tKd1.setText(" 0 ");
            }
            Go.kd1 = d6;
            bl2 = true;
        }
        if (object == this.tKd3) {
            double d7 = Double.parseDouble(this.tKd3.getText().trim());
            if (d7 < 0.0) {
                d7 = 0.0;
                this.tKd3.setText(" 0 ");
            }
            Go.kd3 = d7;
            bl2 = true;
        }
        if (object == this.tNbe) {
            double d8 = Double.parseDouble(this.tNbe.getText().trim());
            if (d8 < 0.0) {
                d8 = 0.0;
                this.tNbe.setText(" 0 ");
            }
            Go.nbe = d8;
            bl2 = true;
        }
        if (object == this.tNbc) {
            double d9 = Double.parseDouble(this.tNbc.getText().trim());
            if (d9 < 0.0) {
                d9 = 0.0;
                this.tNbc.setText(" 0 ");
            }
            Go.nbc = d9;
            bl2 = true;
        }
        if (object == this.bLoad || object == this.tURL || bl2) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            this.bPlay.setText("Start");
            this.bPlay.setEnabled(false);
            this.sysInit = false;
            String string = this.tURL.getText().trim();
            this.initPDB(string);
            this.tNumRes.setText("" + this.go.n);
            this.bPlay.setEnabled(true);
        }
        boolean bl3 = false;
        if (object == this.bUseWL) {
            boolean bl4 = this.go.useWL = !this.go.useWL;
            if (this.go.useWL) {
                bl3 = true;
            }
        }
        if (object == this.tPerc) {
            d = Double.parseDouble(this.tPerc.getText().trim());
            if ((d *= 0.01) < 1.0E-4) {
                d = 1.0E-4;
                this.tPerc.setText(" " + this.dfper.format(d));
            }
            WL.perc = d;
        }
        if (object == this.tLnf0) {
            WL.lnf0 = d = Double.parseDouble(this.tLnf0.getText().trim());
            if (this.go.useWL) {
                bl3 = true;
            }
        }
        if (bl3) {
            this.go.initWL();
        }
        boolean bl5 = bl = object == this.bPlay && this.timer == null;
        if (object == this.bPlay) {
            if (this.timer == null) {
                this.bPlay.setText("Stop");
            } else {
                this.timer.stop();
                this.timer = null;
                this.bPlay.setText("Start");
                this.repaint();
            }
        }
        if (bl) {
            if (!this.sysInit) {
                return;
            }
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            this.step = 0;
            this.repaint();
            this.timer = new Timer(this.delay, this);
            this.timer.start();
        }
        if (object == this.timer) {
            if (!this.sysInit) {
                return;
            }
            for (int i = 0; i < this.speed; ++i) {
                this.go.vv();
            }
            this.tEpot.setText(this.df.format(this.go.epot) + "  ");
            this.tEkin.setText(this.df.format(2.0 * this.go.ekin / (double)this.go.dof / 0.001987213193116635) + "  ");
            if (this.go.useWL) {
                this.tLnf.setText(this.dfsci.format(this.go.wl.lnf) + "  ");
                this.tFlatness.setText(this.dfper.format(this.go.wl.flatness) + "  ");
            }
            this.repaint();
        }
    }
}

