/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;

class Go {
    static double kb = 200.0;
    static double ka = 40.0;
    static double kd1 = 1.0;
    static double kd3 = 0.5;
    static double nbe = 1.0;
    static double nbc = 4.0;
    static double rc = 10.0;
    double mddt = 0.002;
    double thermdt = 0.01;
    int n = 0;
    int nmax = 1024;
    int dof = 0;
    String[] res;
    double[][] xref;
    double[][] x;
    double[][] v;
    double[][] f;
    double epot;
    double ekin;
    double epotRef;
    static final double mass = 1.0;
    static final double kB = 0.001987213193116635;
    static double kT = 0.5961639579349904;
    boolean useWL = false;
    WL wl;
    Random rng = new Random();
    double[] bref;
    double[] aref;
    double[] dref;
    double[][] r2ref;
    boolean[][] iscont;
    double[] dx = new double[3];
    double[] gi = new double[3];
    double[] gj = new double[3];
    double[] gk = new double[3];
    double[] gl = new double[3];
    double fscal = 1.0;

    Go() {
        this.res = new String[this.nmax];
        this.xref = new double[this.nmax][3];
    }

    Go(InputStream inputStream) throws Exception {
        this();
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("ENDMDL") && !string.startsWith("TER")) {
            String string2;
            if (!string.startsWith("ATOM") || !(string2 = string.substring(12, 16).trim()).equals("CA")) continue;
            this.res[this.n] = string.substring(17, 20).trim();
            this.xref[this.n][0] = Double.parseDouble(string.substring(31, 39).trim());
            this.xref[this.n][1] = Double.parseDouble(string.substring(39, 47).trim());
            this.xref[this.n][2] = Double.parseDouble(string.substring(47, 55).trim());
            ++this.n;
            if (this.n < this.nmax) continue;
            this.nmax += 1024;
            double[][] dArray = new double[this.nmax][3];
            String[] stringArray = new String[this.nmax];
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.xref[i][j] = dArray[i][j];
                }
                stringArray[i] = this.res[i];
            }
            this.xref = dArray;
            this.res = stringArray;
        }
        System.out.println("" + this.n + " residues");
        this.dof = 3 * this.n - 6;
    }

    void initPot() {
        int n;
        this.bref = new double[this.n - 1];
        for (n = 0; n < this.n - 1; ++n) {
            this.bref[n] = rv3.dist(this.xref[n], this.xref[n + 1]);
        }
        this.aref = new double[this.n - 2];
        for (n = 0; n < this.n - 2; ++n) {
            this.aref[n] = rv3.ang(this.xref[n], this.xref[n + 1], this.xref[n + 2], null, null, null);
        }
        this.dref = new double[this.n - 3];
        for (n = 0; n < this.n - 3; ++n) {
            this.dref[n] = rv3.dih(this.xref[n], this.xref[n + 1], this.xref[n + 2], this.xref[n + 3], null, null, null, null);
        }
        this.r2ref = new double[this.n][this.n];
        this.iscont = new boolean[this.n][this.n];
        for (n = 0; n < this.n - 1; ++n) {
            for (int i = n + 1; i < this.n; ++i) {
                double d = rv3.dist(this.xref[n], this.xref[i]);
                double d2 = d * d;
                this.r2ref[i][n] = d2;
                this.r2ref[n][i] = d2;
                if (i < n + 4 || !(d < rc)) continue;
                this.iscont[i][n] = true;
                this.iscont[n][i] = true;
                System.out.println("contact " + n + " and " + i);
            }
            this.r2ref[n][n] = 0.0;
        }
    }

    void initMD() {
        this.x = new double[this.n][3];
        this.v = new double[this.n][3];
        this.f = new double[this.n][3];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.x[i][j] = this.xref[i][j] + (this.rng.nextDouble() - 0.5) * 0.2;
                this.v[i][j] = 0.0;
                this.f[i][j] = 0.0;
            }
        }
        this.epotRef = this.force(this.f, this.xref);
        this.epot = this.force(this.f, this.x);
        this.ekin = this.ekinet(this.v);
    }

    void initWL() {
        double d;
        double d2;
        if (this.epotRef < 0.0) {
            d2 = this.epotRef * 0.9;
            d = -d2;
        } else {
            d2 = this.epotRef;
            d = this.epotRef * 3.0;
        }
        this.wl = new WL(d2, d);
    }

    void initSys() {
        this.initPot();
        this.initMD();
        this.initWL();
    }

    private double force(double[][] dArray, double[][] dArray2) {
        int n;
        double d = nbc * nbc;
        double d2 = 0.0;
        for (n = 0; n < this.n; ++n) {
            rv3.zero(dArray[n]);
        }
        for (n = 0; n < this.n - 1; ++n) {
            d2 += this.harmonic(dArray2[n], dArray2[n + 1], this.bref[n], kb, dArray[n], dArray[n + 1]);
        }
        for (n = 0; n < this.n - 2; ++n) {
            d2 += this.angle(dArray2[n], dArray2[n + 1], dArray2[n + 2], this.aref[n], kb, dArray[n], dArray[n + 1], dArray[n + 2]);
        }
        for (n = 0; n < this.n - 3; ++n) {
            d2 += this.dihedral(dArray2[n], dArray2[n + 1], dArray2[n + 2], dArray2[n + 3], this.dref[n], kd1, kd3, dArray[n], dArray[n + 1], dArray[n + 2], dArray[n + 3]);
        }
        for (n = 0; n < this.n - 4; ++n) {
            for (int i = n + 4; i < this.n; ++i) {
                double d3;
                double d4;
                rv3.diff(this.dx, dArray2[n], dArray2[i]);
                double d5 = rv3.sqr(this.dx);
                double d6 = 1.0 / d5;
                if (this.iscont[n][i]) {
                    d5 = this.r2ref[n][i] * d6;
                    double d7 = d5 * d5;
                    d4 = d7 * d5;
                    double d8 = d7 * d4;
                    d3 = nbe * 60.0 * (d5 - 1.0) * d8 * d6;
                    d2 += nbe * (5.0 * d5 - 6.0) * d8;
                } else {
                    d5 = d / d5;
                    d4 = d5 * d5 * d5;
                    d4 *= d4;
                    d3 = nbe * 12.0 * d4 * d6;
                    d2 += nbe * d4;
                }
                rv3.sinc(dArray[n], this.dx, d3);
                rv3.sinc(dArray[i], this.dx, -d3);
            }
        }
        return d2;
    }

    private double harmonic(double[] dArray, double[] dArray2, double d, double d2, double[] dArray3, double[] dArray4) {
        rv3.diff(this.dx, dArray, dArray2);
        double d3 = rv3.norm(this.dx);
        double d4 = d3 - d;
        double d5 = d2 * d4 / d3;
        rv3.sinc(dArray3, this.dx, -d5);
        rv3.sinc(dArray4, this.dx, d5);
        return 0.5 * d2 * d4 * d4;
    }

    private double angle(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double[] dArray4, double[] dArray5, double[] dArray6) {
        double d3 = rv3.ang(dArray, dArray2, dArray3, this.gi, this.gj, this.gk);
        double d4 = d3 - d;
        double d5 = -d2 * d4;
        rv3.sinc(dArray4, this.gi, d5);
        rv3.sinc(dArray5, this.gj, d5);
        rv3.sinc(dArray6, this.gk, d5);
        return 0.5 * d2 * d4 * d4;
    }

    private double dihedral(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double d2, double d3, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) {
        double d4 = rv3.dih(dArray, dArray2, dArray3, dArray4, this.gi, this.gj, this.gk, this.gl);
        double d5 = d4 - d;
        if (d5 > Math.PI) {
            d5 -= Math.PI * 2;
        } else if (d5 < -Math.PI) {
            d5 += Math.PI * 2;
        }
        double d6 = -d2 * Math.sin(d5) - d3 * 3.0 * Math.sin(3.0 * d5);
        rv3.sinc(dArray5, this.gi, d6);
        rv3.sinc(dArray6, this.gj, d6);
        rv3.sinc(dArray7, this.gk, d6);
        rv3.sinc(dArray8, this.gl, d6);
        return d2 * (1.0 - Math.cos(d5)) + d3 * (1.0 - Math.cos(3.0 * d5));
    }

    void vv() {
        int n;
        for (n = 0; n < this.n; ++n) {
            rv3.sinc(this.v[n], this.f[n], this.fscal * 0.5 * this.mddt / 1.0);
            rv3.sinc(this.x[n], this.v[n], this.mddt);
        }
        this.epot = this.force(this.f, this.x);
        this.fscal = this.wl != null && this.useWL ? this.wl.add(this.epot) * kT : 1.0;
        for (n = 0; n < this.n; ++n) {
            rv3.sinc(this.v[n], this.f[n], this.fscal * 0.5 * this.mddt / 1.0);
        }
        this.rmcom(this.v);
        this.ekin = this.vrescale(this.v);
    }

    private double ekinet(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            d += 0.5 * rv3.sqr(dArray[i]);
        }
        return d;
    }

    private void rmcom(double[][] dArray) {
        for (int i = 0; i < 3; ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < this.n; ++n) {
                d += dArray[n][i];
            }
            d /= (double)this.n;
            for (n = 0; n < this.n; ++n) {
                double[] dArray2 = dArray[n];
                int n2 = i;
                dArray2[n2] = dArray2[n2] - d;
            }
        }
    }

    private double vrescale(double[][] dArray) {
        double d;
        double d2;
        double d3 = this.ekinet(dArray);
        double d4 = d3 + ((d2 = 0.5 * kT * (double)this.dof) - d3) * this.thermdt + (d = 2.0 * Math.sqrt(d3 * d2 * this.thermdt / (double)this.dof)) * this.rng.nextGaussian();
        if (d4 < 0.0) {
            d4 = d3;
        }
        double d5 = Math.sqrt(d4 / d3);
        for (int i = 0; i < this.n; ++i) {
            int n = 0;
            while (n < 3) {
                double[] dArray2 = dArray[i];
                int n2 = n++;
                dArray2[n2] = dArray2[n2] * d5;
            }
        }
        return d4;
    }

    static void setT(double d) {
        kT = 0.001987213193116635 * d;
    }

    static double getT() {
        return kT / 0.001987213193116635;
    }
}

