/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

class Atom {
    private static final int R = 120;
    private static final int hx = 45;
    private static final int hy = 45;
    private static int maxr;
    public static final int nBalls = 16;
    double spotlightAmp = 0.4;
    double rContrast = 0.7;
    double zContrast = 2.0;
    private static byte[] data;
    private int Rl = 100;
    private int Gl = 100;
    private int Bl = 100;
    private Image[] balls;
    double relRadius = 1.0;
    private static Component component;

    Atom(int n, int n2, int n3) {
        this.setRGB(n, n2, n3);
    }

    Atom(double d, double d2, double d3) {
        this.setRGB(d, d2, d3);
    }

    Atom(double d, double d2, double d3, double d4) {
        this(d, d2, d3);
        this.relRadius = d4;
    }

    Atom(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.relRadius = d4;
        this.rContrast = d5;
        this.spotlightAmp = d6;
        this.zContrast = d7;
        this.setRGB(d, d2, d3);
    }

    void setRGB(int n, int n2, int n3) {
        this.Rl = n;
        this.Gl = n2;
        this.Bl = n3;
        this.makeBalls();
    }

    void setRGB(double d, double d2, double d3) {
        this.Rl = (int)(256.0 * d - 1.0E-6);
        this.Gl = (int)(256.0 * d2 - 1.0E-6);
        this.Bl = (int)(256.0 * d3 - 1.0E-6);
        this.makeBalls();
    }

    private int blend(double d, double d2, double d3) {
        return (int)(d2 + (d - d2) * d3);
    }

    private void makeBalls() {
        this.balls = new Image[16];
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < 16; ++i) {
            double d = (this.zContrast * (double)i / 15.0 + 1.0) / (this.zContrast + 1.0);
            for (int j = maxr; j >= 0; --j) {
                double d2 = 1.0 - 1.0 * (double)j / (double)maxr;
                double d3 = 1.0 - this.rContrast * (double)j / (double)maxr;
                double d4 = 1.0 - d2 * this.spotlightAmp;
                byArray[j] = (byte)this.blend(this.blend((double)this.Rl * d3, 255.0, d4), 0.0, d);
                byArray2[j] = (byte)this.blend(this.blend((double)this.Gl * d3, 255.0, d4), 0.0, d);
                byArray3[j] = (byte)this.blend(this.blend((double)this.Bl * d3, 255.0, d4), 0.0, d);
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, maxr + 1, byArray, byArray2, byArray3, 0);
            this.balls[i] = component.createImage(new MemoryImageSource(240, 240, (ColorModel)indexColorModel, data, 0, 240));
        }
    }

    void paint(Graphics graphics, int n, int n2, int n3, double d) {
        if (this.balls == null) {
            this.makeBalls();
        }
        Image image = this.balls[n3];
        int n4 = (int)(d * 2.0 + 0.5);
        graphics.drawImage(image, n - n4 / 2, n2 - n4 / 2, n4, n4, null);
    }

    static {
        data = new byte[57600];
        for (int i = -120; i < 120; ++i) {
            int n = (int)(Math.sqrt(14400 - i * i) + 0.5);
            for (int j = -n; j < n; ++j) {
                int n2 = j + 45;
                int n3 = i + 45;
                int n4 = (int)(Math.sqrt(n2 * n2 + n3 * n3) + 0.5);
                if (n4 > maxr) {
                    maxr = n4;
                }
                Atom.data[(i + 120) * 240 + (j + 120)] = n4 <= 0 ? (byte)1 : (byte)n4;
            }
        }
        component = new Applet();
    }
}

